/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.misc;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.settings.IKeyConflictContext;
import org.lwjgl.util.vector.Vector4f;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.gui.IScreenBase;

public class Misc {
    public static void minecraftOrtho(ScaledResolution scaledresolution) {
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
    }

    public static Path quickFileBackupMove(Path file) throws IOException {
        Path backupPath = null;
        int backupNumber = 0;
        while (Files.exists(backupPath = file.resolveSibling(file.getFileName().toString() + ".backup" + backupNumber), new LinkOption[0])) {
            ++backupNumber;
        }
        Files.move(file, backupPath, new CopyOption[0]);
        return backupPath;
    }

    public static void safeMoveAndReplace(Path from, Path to, boolean backupFrom) throws IOException {
        Path fromBackupPath;
        Path backupPath;
        block8: {
            backupPath = null;
            fromBackupPath = null;
            if (backupFrom) {
                while (true) {
                    try {
                        fromBackupPath = Misc.quickFileBackupMove(from);
                        break block8;
                    }
                    catch (IOException ioe2) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
            fromBackupPath = from;
        }
        if (Files.exists(to, new LinkOption[0])) {
            backupPath = Misc.quickFileBackupMove(to);
        }
        Files.move(fromBackupPath, to, new CopyOption[0]);
        if (backupPath != null) {
            Files.delete(backupPath);
        }
    }

    public static void deleteFile(Path file, int attempts) throws IOException {
        --attempts;
        try {
            Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                    if (iOException != null) {
                        throw iOException;
                    }
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            if (attempts > 0) {
                MinimapLogs.LOGGER.info("Failed to delete file/folder! Retrying... " + attempts);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Misc.deleteFile(file, attempts);
            }
            throw e;
        }
    }

    public static boolean inputMatchesKeyBinding(boolean mouse, int code, KeyBinding kb, IKeyConflictContext conflictContext) {
        if (code == 0) {
            return false;
        }
        if (mouse) {
            code -= 100;
        }
        return kb != null && kb.func_151463_i() == code && kb.getKeyModifier().isActive(conflictContext);
    }

    public static boolean screenShouldSkipWorldRender(IXaeroMinimap modMain, GuiScreen screen, boolean checkOtherMod) {
        return screen instanceof IScreenBase && ((IScreenBase)screen).shouldSkipWorldRender() || checkOtherMod && modMain.getSupportMods().worldmap() && modMain.getSupportMods().worldmapSupport.screenShouldSkipWorldRender(screen);
    }

    public static long getChunkPosAsLong(Chunk chunk) {
        return ChunkPos.func_77272_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b);
    }

    public static Field getFieldReflection(Class<?> c, String name1, String name2, String name3, String name4) {
        Field field = null;
        try {
            field = c.getDeclaredField(name1);
        }
        catch (NoSuchFieldException e) {
            field = Misc.getFieldReflection(c, name2, name3, name4);
        }
        return field;
    }

    public static Field getFieldReflection(Class<?> c, String name1, String name2, String name3) {
        Field field = null;
        try {
            field = c.getDeclaredField(name1);
        }
        catch (NoSuchFieldException e) {
            field = Misc.getFieldReflection(c, name2, name3);
        }
        return field;
    }

    public static Field getFieldReflection(Class<?> c, String name1, String name2) {
        Field field = null;
        try {
            field = c.getDeclaredField(name1);
        }
        catch (NoSuchFieldException e) {
            try {
                field = c.getDeclaredField(name2);
            }
            catch (NoSuchFieldException e1) {
                throw new RuntimeException(e1);
            }
        }
        return field;
    }

    public static <A, B> B getReflectFieldValue(A parentObject, Field field) {
        boolean accessibleBU = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(parentObject);
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        field.setAccessible(accessibleBU);
        return (B)result;
    }

    public static Method getMethodReflection(Class<?> c, String obfuscatedName, String shortObfuscatedName, String name, Class<?> ... parameters) {
        Method method = null;
        try {
            method = c.getDeclaredMethod(obfuscatedName, parameters);
        }
        catch (NoSuchMethodException e) {
            method = Misc.getMethodReflection(c, shortObfuscatedName, name, parameters);
        }
        return method;
    }

    public static Method getMethodReflection(Class<?> c, String obfuscatedName, String name, Class<?> ... parameters) {
        Method method = null;
        try {
            method = c.getDeclaredMethod(obfuscatedName, parameters);
        }
        catch (NoSuchMethodException e) {
            try {
                method = c.getDeclaredMethod(name, parameters);
            }
            catch (NoSuchMethodException e1) {
                throw new RuntimeException(e1);
            }
        }
        return method;
    }

    public static <A, B> B getReflectMethodValue(A parentObject, Method method, Object ... arguments) {
        boolean accessibleBU = method.isAccessible();
        method.setAccessible(true);
        Object result = null;
        try {
            result = method.invoke(parentObject, arguments);
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        method.setAccessible(accessibleBU);
        return (B)result;
    }

    public static void download(BufferedOutputStream output, InputStream input) throws IOException {
        int read;
        byte[] buffer = new byte[256];
        while ((read = input.read(buffer, 0, buffer.length)) >= 0) {
            output.write(buffer, 0, read);
        }
        output.flush();
        input.close();
        output.close();
    }

    public static boolean hasItem(EntityPlayer player, Item item) {
        return Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_184439_c, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_70460_b, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, 9, item);
    }

    public static boolean hasItem(NonNullList<ItemStack> inventory, int limit, Item item) {
        for (int i = 0; i < inventory.size() && (limit == -1 || i < limit); ++i) {
            if (inventory.get(i) == null || ((ItemStack)inventory.get(i)).func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static void setFieldText(GuiTextField field, String text) {
        Misc.setFieldText(field, text, -1);
    }

    public static void setFieldText(GuiTextField field, String text, int color) {
        field.func_146193_g(color);
        if (field.func_146179_b().equals(text)) {
            return;
        }
        field.func_146180_a(text);
    }

    private static float getFromMatrix(float[] matrix, int col, int row) {
        return matrix[col + 4 * row];
    }

    public static void transformVector4f(Vector4f vec, float[] matrix) {
        float x = vec.getX() * Misc.getFromMatrix(matrix, 0, 0) + vec.getY() * Misc.getFromMatrix(matrix, 0, 1) + vec.getZ() * Misc.getFromMatrix(matrix, 0, 2) + vec.getW() * Misc.getFromMatrix(matrix, 0, 3);
        float y = vec.getX() * Misc.getFromMatrix(matrix, 1, 0) + vec.getY() * Misc.getFromMatrix(matrix, 1, 1) + vec.getZ() * Misc.getFromMatrix(matrix, 1, 2) + vec.getW() * Misc.getFromMatrix(matrix, 1, 3);
        float z = vec.getX() * Misc.getFromMatrix(matrix, 2, 0) + vec.getY() * Misc.getFromMatrix(matrix, 2, 1) + vec.getZ() * Misc.getFromMatrix(matrix, 2, 2) + vec.getW() * Misc.getFromMatrix(matrix, 2, 3);
        float w = vec.getX() * Misc.getFromMatrix(matrix, 3, 0) + vec.getY() * Misc.getFromMatrix(matrix, 3, 1) + vec.getZ() * Misc.getFromMatrix(matrix, 3, 2) + vec.getW() * Misc.getFromMatrix(matrix, 3, 3);
        vec.set(x, y, z, w);
    }

    public static IBlockState getStateById(int id) {
        try {
            return Block.func_176220_d((int)id);
        }
        catch (Exception e) {
            return Misc.getDefaultBlockStateForStateId(id);
        }
    }

    private static IBlockState getDefaultBlockStateForStateId(int id) {
        try {
            Block block = Block.func_176220_d((int)id).func_177230_c();
            return block.func_176223_P();
        }
        catch (Exception e) {
            return Blocks.field_150350_a.func_176223_P();
        }
    }

    public static Vec3d getLookVec() {
        float pitchCos = ActiveRenderInfo.func_178809_c();
        float pitchSin = Misc.getPitchSin();
        return new Vec3d((double)(-ActiveRenderInfo.func_178803_d() * pitchCos), (double)(-pitchSin), (double)(ActiveRenderInfo.func_178808_b() * pitchCos));
    }

    public static double getYawRadians() {
        float yawSin = ActiveRenderInfo.func_178803_d();
        float yawCos = ActiveRenderInfo.func_178808_b();
        double aSin = Math.asin(yawSin);
        if (yawCos > 0.0f) {
            return aSin;
        }
        if (aSin > 0.0) {
            return Math.PI - aSin;
        }
        return -Math.PI - aSin;
    }

    public static double getPitchRadians() {
        return Math.asin(Misc.getPitchSin());
    }

    private static float getPitchSin() {
        if (ActiveRenderInfo.func_178808_b() != 0.0f) {
            return ActiveRenderInfo.func_178807_f() / ActiveRenderInfo.func_178808_b();
        }
        return ActiveRenderInfo.func_178805_e() / -ActiveRenderInfo.func_178803_d();
    }
}

